﻿/*
	USAGE:
		#include "gameProgram/loadgameXml.as"
		var success_prom = loadGameXml( savedGame_xml );
	
	action:		Over-writes RAM, and restores a saved game.
	input:		XML  or  string containing XML  representing a saved game
	output:		promise with RAM-data
	requires:	loadGame.as
*/
#include "gameProgram/loadGame.as"
function loadGameXml( input ){
	#include "gameFunctions/readXml.as"
	#include "functions/VOW.as"
	var vow = VOW.make();
	var load_xml;
	
	// ABORT:  no data
	if(!input)		return VOW.broken("No data");
	
	
	// convert input => XML
	var isXmlInput = (input instanceof XML);
	var isStringInput = ( typeof(input) === "string" );
	if( isXmlInput )
	{// xml
		load_xml = input;
	}// xml
	else if( isStringInput )
	{// string
		// fix "undefined" stored as strings
		var loadString = String( input );
		loadString = loadString.split("str_undefined").join("undefined");
		
		// convert string to XML
		XML.prototype.ignoreWhite = true;
		load_xml = new XML( loadString );
	}// string
	else
	{// other
		return VOW.broken("No data");
	}// other
	
	
	
	// convert XML to data
	var loadData = {};
	readXml( load_xml.firstChild, loadData );
	
	// load data into RAM & teleport
	var result:Boolean = ROOT.restoreData( loadData );
	
	if(result){
		vow.keep( loadData );
	}else{
		return VOW.broken("Invalid data");
	}
	
	return vow.promise;
}// loadGameXml()